//
//  NSData+MCAdditions.h
//  MCFoundation
//
//  Created by Michael Clark on 10/07/2005.
//  Copyright 2005 Marketcircle Inc. All rights reserved.
//

#import <Foundation/Foundation.h>


@interface NSData (MCAdditions)

// Convenience methods
- (NSString*)stringForEncoding: (NSStringEncoding)encoding;
- (NSString*)stringForMacOSRomanEncoding;
- (NSString*)stringForUTF8Encoding;

- (NSString *)mcHexString;

- (NSData *)MD5DigestData;

// Basically just calls isprint() and iscntrl() on each byte to see if it is a readable string and creates a new string with just those characters
- (NSString *)recoveredReadableString;
@end

@interface NSData (Base64Encoding)
+ (BOOL)isCharacterPartOfBase64Encoding:(char)inChar;
+ (NSData *)dataWithBase64EncodedString:(NSString *)inBase64String;
- (id)initWithBase64EncodedString:(NSString *)inBase64String;
- (NSString *)base64EncodingWithLineLength:(unsigned int)inLineLength;
- (NSString *)base64Encoding;
@end


@interface NSData (MCAliasDetection)

/* Returns whether 'self' passes some tests on the format of the data typical to an alias object. */
- (BOOL)mc_isLikelyAlias;

@end
